/*!
 * Cropper v0.7.2
 * https://github.com/fengyuanchen/cropper
 *
 * Copyright 2014 Fengyuan Chen
 * Released under the MIT license
 */

!function(a){"function"==typeof define&&define.amd?define(["jquery"],a):a(jQuery)}(function(a){"use strict";var b=a(window),c=a(document),d=!0,e=!1,f=null,g=0/0,h=1/0,i="undefined",j="directive",k=".cropper",l=/^(e|n|w|s|ne|nw|sw|se|all|crop|move|zoom)$/,m=/^(x|y|width|height)$/,n=/^(naturalWidth|naturalHeight|width|height|aspectRatio|ratio)$/,o="cropper-modal",p="cropper-hidden",q="cropper-invisible",r="cropper-move",s="cropper-crop",t="cropper-disabled",u="mousedown touchstart",v="mousemove touchmove",w="mouseup mouseleave touchend touchleave touchcancel",x="wheel mousewheel DOMMouseScroll",y="resize"+k,z="dblclick",A="build"+k,B="built"+k,C="dragstart"+k,D="dragmove"+k,E="dragend"+k,F=function(a){return"number"==typeof a},G=function(b,c){this.element=b,this.$element=a(b),this.defaults=a.extend({},G.DEFAULTS,a.isPlainObject(c)?c:{}),this.$original=f,this.ready=e,this.built=e,this.cropped=e,this.rotated=e,this.disabled=e,this.replaced=e,this.init()},H=Math.round,I=Math.sqrt,J=Math.min,K=Math.max,L=Math.abs,M=Math.sin,N=Math.cos,O=parseFloat;G.prototype={constructor:G,support:{canvas:a.isFunction(a("<canvas>")[0].getContext)},init:function(){var b=this.defaults;a.each(b,function(a,c){switch(a){case"aspectRatio":b[a]=L(O(c))||g;break;case"minWidth":case"minHeight":b[a]=L(O(c))||0;break;case"maxWidth":case"maxHeight":b[a]=L(O(c))||h}}),this.image={rotate:0},this.load()},load:function(){var b,c,f=this,g=this.$element,h=this.element,i=this.image;g.is("img")?c=g.attr("src"):g.is("canvas")&&this.support.canvas&&(c=h.toDataURL()),c&&(this.$clone&&this.$clone.remove(),this.replaced&&(this.replaced=e,i.rotate=0),this.$clone=b=a('<img src="'+c+'">'),b.one("load",function(){i.naturalWidth=this.naturalWidth||b.width(),i.naturalHeight=this.naturalHeight||b.height(),i.aspectRatio=i.naturalWidth/i.naturalHeight,f.url=c,f.ready=d,f.build()}),b.addClass(q).prependTo("body"))},build:function(){var b,e,f=this.$element,g=this.defaults;this.ready&&(this.built&&this.unbuild(),f.one(A,g.build),b=a.Event(A),f.trigger(b),b.isDefaultPrevented()||(this.$cropper=e=a(G.TEMPLATE),f.addClass(p),this.$clone.removeClass(q).prependTo(e),this.rotated||(this.$original=this.$clone.clone(),this.originalImage=a.extend({},this.image)),this.$container=f.parent(),this.$container.append(e),this.$canvas=e.find(".cropper-canvas"),this.$dragger=e.find(".cropper-dragger"),this.$viewer=e.find(".cropper-viewer"),g.autoCrop?this.cropped=d:this.$dragger.addClass(p),g.dragCrop&&this.setDragMode("crop"),g.modal&&this.$canvas.addClass(o),!g.dashed&&this.$dragger.find(".cropper-dashed").addClass(p),!g.movable&&this.$dragger.find(".cropper-face").addClass(p),!g.resizable&&this.$dragger.find(".cropper-line, .cropper-point").addClass(p),this.$scope=g.multiple?this.$cropper:c,this.addListeners(),this.initPreview(),this.built=d,this.update(),f.one(B,g.built),f.trigger(B)))},unbuild:function(){this.built&&(this.built=e,this.removeListeners(),this.$preview.empty(),this.$preview=f,this.$dragger=f,this.$canvas=f,this.$container=f,this.$cropper.remove(),this.$cropper=f)},update:function(a){this.initContainer(),this.initCropper(),this.initImage(),this.initDragger(),a?(this.setData(a,d),this.setDragMode("crop")):this.setData(this.defaults.data)},resize:function(){clearTimeout(this.resizing),this.resizing=setTimeout(a.proxy(this.update,this,this.getData()),200)},preview:function(){var b=this.image,c=this.dragger,d=b.width,e=b.height,f=c.left-b.left,g=c.top-b.top;this.$viewer.find("img").css({width:H(d),height:H(e),marginLeft:-H(f),marginTop:-H(g)}),this.$preview.each(function(){var b=a(this),h=b.width()/c.width;b.find("img").css({width:H(d*h),height:H(e*h),marginLeft:-H(f*h),marginTop:-H(g*h)})})},addListeners:function(){var c=this.defaults;this.$element.on(C,c.dragstart).on(D,c.dragmove).on(E,c.dragend),this.$cropper.on(u,this._dragstart=a.proxy(this.dragstart,this)).on(z,this._dblclick=a.proxy(this.dblclick,this)),c.zoomable&&this.$cropper.on(x,this._wheel=a.proxy(this.wheel,this)),this.$scope.on(v,this._dragmove=a.proxy(this.dragmove,this)).on(w,this._dragend=a.proxy(this.dragend,this)),b.on(y,this._resize=a.proxy(this.resize,this))},removeListeners:function(){var a=this.defaults;this.$element.off(C,a.dragstart).off(D,a.dragmove).off(E,a.dragend),this.$cropper.off(u,this._dragstart).off(z,this._dblclick),a.zoomable&&this.$cropper.off(x,this._wheel),this.$scope.off(v,this._dragmove).off(w,this._dragend),b.off(y,this._resize)},initPreview:function(){var b='<img src="'+this.url+'">';this.$preview=a(this.defaults.preview),this.$preview.html(b),this.$viewer.html(b)},initContainer:function(){var a=this.$container;this.container={width:K(a.width(),300),height:K(a.height(),150)}},initCropper:function(){var a,b=this.container,c=this.image;c.naturalWidth*b.height/c.naturalHeight-b.width>=0?(a={width:b.width,height:b.width/c.aspectRatio,left:0},a.top=(b.height-a.height)/2):(a={width:b.height*c.aspectRatio,height:b.height,top:0},a.left=(b.width-a.width)/2),this.$cropper.css({width:H(a.width),height:H(a.height),left:H(a.left),top:H(a.top)}),this.cropper=a},initImage:function(){var b=this.image,c=this.cropper,d={_width:c.width,_height:c.height,width:c.width,height:c.height,left:0,top:0,ratio:c.width/b.naturalWidth};this.defaultImage=a.extend({},b,d),b._width!==c.width||b._height!==c.height?a.extend(b,d):b=a.extend(d,b),this.image=b,this.renderImage()},renderImage:function(a){var b=this.image;"zoom"===a&&(b.left-=(b.width-b.oldWidth)/2,b.top-=(b.height-b.oldHeight)/2),b.left=J(K(b.left,b._width-b.width),0),b.top=J(K(b.top,b._height-b.height),0),this.$clone.css({width:H(b.width),height:H(b.height),marginLeft:H(b.left),marginTop:H(b.top)}),a&&(this.defaults.done(this.getData()),this.preview())},initDragger:function(){var b,c=this.defaults,d=this.cropper,e=c.aspectRatio||this.image.aspectRatio,f=this.image.ratio;b=d.height*e-d.width>=0?{height:d.width/e,width:d.width,left:0,top:(d.height-d.width/e)/2,maxWidth:d.width,maxHeight:d.width/e}:{height:d.height,width:d.height*e,left:(d.width-d.height*e)/2,top:0,maxWidth:d.height*e,maxHeight:d.height},b.minWidth=0,b.minHeight=0,c.aspectRatio?(isFinite(c.maxWidth)?(b.maxWidth=J(b.maxWidth,c.maxWidth*f),b.maxHeight=b.maxWidth/e):isFinite(c.maxHeight)&&(b.maxHeight=J(b.maxHeight,c.maxHeight*f),b.maxWidth=b.maxHeight*e),c.minWidth>0?(b.minWidth=K(0,c.minWidth*f),b.minHeight=b.minWidth/e):c.minHeight>0&&(b.minHeight=K(0,c.minHeight*f),b.minWidth=b.minHeight*e)):(b.maxWidth=J(b.maxWidth,c.maxWidth*f),b.maxHeight=J(b.maxHeight,c.maxHeight*f),b.minWidth=K(0,c.minWidth*f),b.minHeight=K(0,c.minHeight*f)),b.minWidth=J(b.maxWidth,b.minWidth),b.minHeight=J(b.maxHeight,b.minHeight),b.height*=.8,b.width*=.8,b.left=(d.width-b.width)/2,b.top=(d.height-b.height)/2,b.oldLeft=b.left,b.oldTop=b.top,this.defaultDragger=b,this.dragger=a.extend({},b)},renderDragger:function(){var a=this.dragger,b=this.cropper;a.width>a.maxWidth?(a.width=a.maxWidth,a.left=a.oldLeft):a.width<a.minWidth&&(a.width=a.minWidth,a.left=a.oldLeft),a.height>a.maxHeight?(a.height=a.maxHeight,a.top=a.oldTop):a.height<a.minHeight&&(a.height=a.minHeight,a.top=a.oldTop),a.left=J(K(a.left,0),b.width-a.width),a.top=J(K(a.top,0),b.height-a.height),a.oldLeft=a.left,a.oldTop=a.top,this.dragger=a,this.defaults.done(this.getData()),this.$dragger.css({width:H(a.width),height:H(a.height),left:H(a.left),top:H(a.top)}),this.preview()},reset:function(b){this.cropped&&(b&&(this.defaults.data={}),this.image=a.extend({},this.defaultImage),this.renderImage(),this.dragger=a.extend({},this.defaultDragger),this.setData(this.defaults.data))},clear:function(){this.cropped&&(this.cropped=e,this.setData({x:0,y:0,width:0,height:0}),this.$canvas.removeClass(o),this.$dragger.addClass(p))},destroy:function(){var a=this.$element;this.ready&&(this.unbuild(),a.removeClass(p).removeData("cropper"),this.rotated&&a.replaceWith(this.$original))},replace:function(b,c){var f,g=this,h=this.$element,i=this.element;b&&b!==this.url&&(c||(this.rotated=e,this.replaced=d),h.is("img")?(h.attr("src",b),this.load()):h.is("canvas")&&this.support.canvas&&(f=i.getContext("2d"),a('<img src="'+b+'">').one("load",function(){i.width=this.width,i.height=this.height,f.clearRect(0,0,i.width,i.height),f.drawImage(this,0,0),g.load()})))},setData:function(b,c){var d=this.cropper,e=this.dragger,g=this.image,h=this.defaults.aspectRatio;this.built&&typeof b!==i&&((b===f||a.isEmptyObject(b))&&(e=a.extend({},this.defaultDragger)),a.isPlainObject(b)&&!a.isEmptyObject(b)&&(c||(this.defaults.data=b),b=this.transformData(b),F(b.x)&&b.x<=d.width-g.left&&(e.left=b.x+g.left),F(b.y)&&b.y<=d.height-g.top&&(e.top=b.y+g.top),h?F(b.width)&&b.width<=e.maxWidth&&b.width>=e.minWidth?(e.width=b.width,e.height=e.width/h):F(b.height)&&b.height<=e.maxHeight&&b.height>=e.minHeight&&(e.height=b.height,e.width=e.height*h):(F(b.width)&&b.width<=e.maxWidth&&b.width>=e.minWidth&&(e.width=b.width),F(b.height)&&b.height<=e.maxHeight&&b.height>=e.minHeight&&(e.height=b.height))),this.dragger=e,this.renderDragger())},getData:function(){var a=this.dragger,b=this.image,c={};return this.built&&(c={x:a.left-b.left,y:a.top-b.top,width:a.width,height:a.height},c=this.transformData(c,d)),c},transformData:function(b,c){var d=this.image.ratio,e={};return a.each(b,function(a,b){b=O(b),m.test(a)&&!isNaN(b)&&(e[a]=c?H(b/d):b*d)}),e},setAspectRatio:function(a){var b="auto"===a;a=O(a),(b||!isNaN(a)&&a>0)&&(this.defaults.aspectRatio=b?g:a,this.built&&(this.initDragger(),this.renderDragger()))},getImageData:function(){var b={};return this.ready&&a.each(this.image,function(a,c){n.test(a)&&(b[a]=c)}),b},getDataURL:function(b,c){var d=a("<canvas>")[0],e=this.getData(),f="";return this.cropped&&this.support.canvas&&(d.width=e.width,d.height=e.height,d.getContext("2d").drawImage(this.$clone[0],e.x,e.y,e.width,e.height,0,0,e.width,e.height),f=d.toDataURL(b,c)),f},setDragMode:function(a){var b=this.$canvas,c=this.defaults,f=e,g=e;if(this.built&&!this.disabled){switch(a){case"crop":c.dragCrop&&(f=d,b.data(j,a));break;case"move":c.movable&&(g=d,b.data(j,a));break;default:b.removeData(j)}b.toggleClass(s,f).toggleClass(r,g)}},enable:function(){this.built&&(this.disabled=e,this.$cropper.removeClass(t))},disable:function(){this.built&&(this.disabled=d,this.$cropper.addClass(t))},rotate:function(a){var b=this.image;a=O(a)||0,this.built&&0!==a&&!this.disabled&&this.defaults.rotatable&&this.support.canvas&&(this.rotated=d,a=b.rotate=(b.rotate+a)%360,this.replace(this.getRotatedDataURL(a),!0))},getRotatedDataURL:function(b){var c=this.$original.clone(),d=a("<canvas>")[0],e=d.getContext("2d"),f=b*Math.PI/180,g=L(b)%180,h=g>90?180-g:g,i=h*Math.PI/180,j=this.originalImage,k=j.naturalWidth,l=j.naturalHeight,m=L(k*N(i)+l*M(i)),n=L(k*M(i)+l*N(i));return d.width=m,d.height=n,e.save(),e.translate(m/2,n/2),e.rotate(f),c.addClass(q).prependTo(this.$cropper),e.drawImage(c[0],-k/2,-l/2,k,l),e.restore(),d.toDataURL()},zoom:function(a){var b,c,d,e=this.image;a=O(a),this.built&&a&&!this.disabled&&this.defaults.zoomable&&(b=e.width*(1+a),c=e.height*(1+a),d=b/e._width,d>10||(1>d&&(b=e._width,c=e._height),this.setDragMode(1>=d?"crop":"move"),e.oldWidth=e.width,e.oldHeight=e.height,e.width=b,e.height=c,e.ratio=e.width/e.naturalWidth,this.renderImage("zoom")))},dblclick:function(){this.disabled||this.setDragMode(this.$canvas.hasClass(s)?"move":"crop")},wheel:function(a){var b,c=a.originalEvent,d=117.25,e=5,f=166.66665649414062,g=.1;this.disabled||(a.preventDefault(),c.deltaY?(b=c.deltaY,b=b%e===0?b/e:b%d===0?b/d:b/f):b=c.wheelDelta?-c.wheelDelta/120:c.detail?c.detail/3:0,this.zoom(b*g))},dragstart:function(b){var c,f,g,h=b.originalEvent.touches,i=b;if(!this.disabled){if(h){if(g=h.length,g>1){if(!this.defaults.zoomable||2!==g)return;i=h[1],this.startX2=i.pageX,this.startY2=i.pageY,c="zoom"}i=h[0]}if(c=c||a(i.target).data(j),l.test(c)){if(b.preventDefault(),f=a.Event(C),this.$element.trigger(f),f.isDefaultPrevented())return;this.directive=c,this.cropping=e,this.startX=i.pageX,this.startY=i.pageY,"crop"===c&&(this.cropping=d,this.$canvas.addClass(o))}}},dragmove:function(b){var c,d,e=b.originalEvent.touches,f=b;if(!this.disabled){if(e){if(d=e.length,d>1){if(!this.defaults.zoomable||2!==d)return;f=e[1],this.endX2=f.pageX,this.endY2=f.pageY}f=e[0]}if(this.directive){if(b.preventDefault(),c=a.Event(D),this.$element.trigger(c),c.isDefaultPrevented())return;this.endX=f.pageX,this.endY=f.pageY,this.dragging()}}},dragend:function(b){var c;if(!this.disabled&&this.directive){if(b.preventDefault(),c=a.Event(E),this.$element.trigger(c),c.isDefaultPrevented())return;this.cropping&&(this.cropping=e,this.$canvas.toggleClass(o,this.cropped&&this.defaults.modal)),this.directive=""}},dragging:function(){var a,b=this.directive,c=this.image,f=this.cropper,g=f.width,h=f.height,i=this.dragger,j=i.width,k=i.height,l=i.left,m=i.top,n=l+j,o=m+k,q=d,r=this.defaults,s=r.aspectRatio,t={x:this.endX-this.startX,y:this.endY-this.startY};switch(s&&(t.X=t.y*s,t.Y=t.x/s),b){case"all":l+=t.x,m+=t.y;break;case"e":if(t.x>=0&&(n>=g||s&&(0>=m||o>=h))){q=e;break}j+=t.x,s&&(k=j/s,m-=t.Y/2),0>j&&(b="w",j=0);break;case"n":if(t.y<=0&&(0>=m||s&&(0>=l||n>=g))){q=e;break}k-=t.y,m+=t.y,s&&(j=k*s,l+=t.X/2),0>k&&(b="s",k=0);break;case"w":if(t.x<=0&&(0>=l||s&&(0>=m||o>=h))){q=e;break}j-=t.x,l+=t.x,s&&(k=j/s,m+=t.Y/2),0>j&&(b="e",j=0);break;case"s":if(t.y>=0&&(o>=h||s&&(0>=l||n>=g))){q=e;break}k+=t.y,s&&(j=k*s,l-=t.X/2),0>k&&(b="n",k=0);break;case"ne":if(s){if(t.y<=0&&(0>=m||n>=g)){q=e;break}k-=t.y,m+=t.y,j=k*s}else t.x>=0?g>n?j+=t.x:t.y<=0&&0>=m&&(q=e):j+=t.x,t.y<=0?m>0&&(k-=t.y,m+=t.y):(k-=t.y,m+=t.y);0>k&&(b="sw",k=0,j=0);break;case"nw":if(s){if(t.y<=0&&(0>=m||0>=l)){q=e;break}k-=t.y,m+=t.y,j=k*s,l+=t.X}else t.x<=0?l>0?(j-=t.x,l+=t.x):t.y<=0&&0>=m&&(q=e):(j-=t.x,l+=t.x),t.y<=0?m>0&&(k-=t.y,m+=t.y):(k-=t.y,m+=t.y);0>k&&(b="se",k=0,j=0);break;case"sw":if(s){if(t.x<=0&&(0>=l||o>=h)){q=e;break}j-=t.x,l+=t.x,k=j/s}else t.x<=0?l>0?(j-=t.x,l+=t.x):t.y>=0&&o>=h&&(q=e):(j-=t.x,l+=t.x),t.y>=0?h>o&&(k+=t.y):k+=t.y;0>j&&(b="ne",k=0,j=0);break;case"se":if(s){if(t.x>=0&&(n>=g||o>=h)){q=e;break}j+=t.x,k=j/s}else t.x>=0?g>n?j+=t.x:t.y>=0&&o>=h&&(q=e):j+=t.x,t.y>=0?h>o&&(k+=t.y):k+=t.y;0>j&&(b="nw",k=0,j=0);break;case"move":c.left+=t.x,c.top+=t.y,this.renderImage("move"),q=e;break;case"zoom":r.zoomable&&(this.zoom(function(a,b,c,d,e,f){return(I(e*e+f*f)-I(c*c+d*d))/I(a*a+b*b)}(c.width,c.height,L(this.startX-this.startX2),L(this.startY-this.startY2),L(this.endX-this.endX2),L(this.endY-this.endY2))),this.endX2=this.startX2,this.endY2=this.startY2);break;case"crop":t.x&&t.y&&(a=this.$cropper.offset(),l=this.startX-a.left,m=this.startY-a.top,j=i.minWidth,k=i.minHeight,t.x>0?t.y>0?b="se":(b="ne",m-=k):t.y>0?(b="sw",l-=j):(b="nw",l-=j,m-=k),this.cropped||(this.cropped=d,this.$dragger.removeClass(p)))}q&&(i.width=j,i.height=k,i.left=l,i.top=m,this.directive=b,this.renderDragger()),this.startX=this.endX,this.startY=this.endY}},G.TEMPLATE=function(a,b){return b=b.split(","),a.replace(/\d+/g,function(a){return b[a]})}('<0 6="5-container"><0 6="5-canvas"></0><0 6="5-dragger"><1 6="5-viewer"></1><1 6="5-8 8-h"></1><1 6="5-8 8-v"></1><1 6="5-face" 3-2="all"></1><1 6="5-7 7-e" 3-2="e"></1><1 6="5-7 7-n" 3-2="n"></1><1 6="5-7 7-w" 3-2="w"></1><1 6="5-7 7-s" 3-2="s"></1><1 6="5-4 4-e" 3-2="e"></1><1 6="5-4 4-n" 3-2="n"></1><1 6="5-4 4-w" 3-2="w"></1><1 6="5-4 4-s" 3-2="s"></1><1 6="5-4 4-ne" 3-2="ne"></1><1 6="5-4 4-nw" 3-2="nw"></1><1 6="5-4 4-sw" 3-2="sw"></1><1 6="5-4 4-se" 3-2="se"></1></0></0>',"div,span,directive,data,point,cropper,class,line,dashed"),G.DEFAULTS={aspectRatio:"auto",data:{},done:a.noop,preview:"",multiple:e,autoCrop:d,dragCrop:d,dashed:d,modal:d,movable:d,resizable:d,zoomable:d,rotatable:d,minWidth:0,minHeight:0,maxWidth:h,maxHeight:h,build:f,built:f,dragstart:f,dragmove:f,dragend:f},G.setDefaults=function(b){a.extend(G.DEFAULTS,b)},G.other=a.fn.cropper,a.fn.cropper=function(b){var c,d=[].slice.call(arguments,1);return this.each(function(){var e,f=a(this),g=f.data("cropper");g||f.data("cropper",g=new G(this,b)),"string"==typeof b&&a.isFunction(e=g[b])&&(c=e.apply(g,d))}),typeof c!==i?c:this},a.fn.cropper.Constructor=G,a.fn.cropper.setDefaults=G.setDefaults,a.fn.cropper.noConflict=function(){return a.fn.cropper=G.other,this}});